﻿Module MainModule

    Sub Main()
        Dim strSaveFilename, strTo, strFrom, strSMTPHost As String
        Try
            '
            '从注册表中获取 Email 和 SMTP 值
            Dim key As Microsoft.Win32.RegistryKey
            key = My.Computer.Registry.LocalMachine.OpenSubKey("SOFTWARE\ExcelAuto")
            If Not key Is Nothing Then
                strTo = key.GetValue("EmailAddress")
                strSMTPHost = key.GetValue("SMTPHost")
                strFrom = "VB2005@example.com"
                '
                '获取用于保存 Excel 文件的临时文件名
                strSaveFilename = My.Computer.FileSystem.SpecialDirectories.Temp & "\Report " & Format(Now, "d-MMM-yyy HH.mm") & ".xlsx"
                PopulateExcelWorkbook(strSaveFilename, False)
                '发送邮件
                SendExcelMailViaSMTP(strTo, strFrom, strSaveFilename, strSMTPHost, True)
                System.Diagnostics.EventLog.WriteEntry(My.Application.Info.AssemblyName, "Successfully sent mail", EventLogEntryType.Information)
            End If
        Catch ex As Exception
            System.Diagnostics.EventLog.WriteEntry(My.Application.Info.AssemblyName, "Exception occurred: " & ex.ToString, EventLogEntryType.Error)
        End Try

    End Sub

End Module
